CREATE TABLE "AB03B"."AB03B01T00"
  (
    "ID_001"      NUMBER(8,0) NOT NULL ENABLE,
    "DESC_ES_001" VARCHAR2(250 BYTE),
    "DESC_EU_001" VARCHAR2(250 BYTE),
    CONSTRAINT "SYS_C0066113" CHECK ("ID_001" IS NOT NULL) ENABLE,
    CONSTRAINT "PK_AB03BT001" PRIMARY KEY ("ID_001") USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645 PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT) TABLESPACE "USERS" ENABLE
  )
  SEGMENT CREATION IMMEDIATE PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING STORAGE
  (
    INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645 PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT
  )
  TABLESPACE "AB0301E00" ;
COMMENT ON COLUMN "AB03B"."AB03B01T00"."ID_001"
IS
  'Secuencia, clave primaria de la tabla';
  COMMENT ON COLUMN "AB03B"."AB03B01T00"."DESC_ES_001"
IS
  'Descripcion en castellano de la Fase';
  COMMENT ON COLUMN "AB03B"."AB03B01T00"."DESC_EU_001"
IS
  'Descripcion en euskera de la Fase';
  COMMENT ON TABLE "AB03B"."AB03B01T00"
IS
  'Tabla de Fases';
  
  /*********************************************************/
  
  CREATE TABLE "AB03B"."AB03B02T00"
  (
    "ID_002"          NUMBER(8,0) NOT NULL ENABLE,
    "ID_001_FASE"     NUMBER(8,0) NOT NULL ENABLE,
    "DESC_ES_002"     VARCHAR2(200 BYTE),
    "DESC_EU_002"     VARCHAR2(200 BYTE),
    CONSTRAINT "PK_AB03B02T00" PRIMARY KEY ("ID_001_FASE", "ID_002") USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645 PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT) TABLESPACE "USERS" ENABLE,
    CONSTRAINT "FK_AB03B02T00_AB03B01T00" FOREIGN KEY ("ID_001_FASE") REFERENCES "AB03B"."AB03B01T00" ("ID_001") ENABLE
  )
  SEGMENT CREATION IMMEDIATE PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING STORAGE
  (
    INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645 PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT
  )
  TABLESPACE "AB0301E00" ;
COMMENT ON COLUMN "AB03B"."AB03B02T00"."ID_002"
IS
  'Secuencia PK de la tabla de tramites';
  COMMENT ON COLUMN "AB03B"."AB03B02T00"."ID_001_FASE"
IS
  'FK a tabla de Fases ';
  COMMENT ON COLUMN "AB03B"."AB03B02T00"."DESC_ES_002"
IS
  'Descripcin en castellano del Tramite ';
  COMMENT ON COLUMN "AB03B"."AB03B02T00"."DESC_EU_002"
IS
  'Descripcion en Euskera del Tramite';
  COMMENT ON TABLE "AB03B"."AB03B02T00"
IS
  'Tabla de trmites';
  
/************************************************************/
CREATE TABLE "AB03B"."AB03B03T00"
  (
    "ID_003"        NUMBER(8,0) NOT NULL ENABLE,
    "DESC_ES_003"   VARCHAR2(150 BYTE),
    "DESC_EU_003"   VARCHAR2(150 BYTE),
    "ACTIVO_SN_003" CHAR(1 BYTE),
    CONSTRAINT "PK_AB03B03T00" PRIMARY KEY ("ID_003") USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645 PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT) TABLESPACE "USERS" ENABLE
  )
  SEGMENT CREATION IMMEDIATE PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING STORAGE
  (
    INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645 PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT
  )
  TABLESPACE "AB0301E00" ;
COMMENT ON COLUMN "AB03B"."AB03B03T00"."ID_003"
IS
  'PK Secuencial de la tabla';
  COMMENT ON COLUMN "AB03B"."AB03B03T00"."DESC_ES_003"
IS
  'Descripcion en Castellano del Cargo';
  COMMENT ON COLUMN "AB03B"."AB03B03T00"."DESC_EU_003"
IS
  'Descripcion Euskera del cargo';
  COMMENT ON COLUMN "AB03B"."AB03B03T00"."ACTIVO_SN_003"
IS
  'Marca de Activo (S/N)';
  COMMENT ON TABLE "AB03B"."AB03B03T00"
IS
  'Tabla de Cargos';

/************************************************************/
CREATE TABLE "AB03B"."AB03B04T00"
  (
    "ID_004"        NUMBER(8,0) NOT NULL ENABLE,
    "NOMBRE_004"   VARCHAR2(150 BYTE),
    "APEL1_004"    VARCHAR2(150 BYTE),
    "APEL2_004"    VARCHAR2(150 BYTE),    
	"ID_003_CARGO"        NUMBER(8,0) NOT NULL ENABLE,
    "ACTIVO_SN_004" CHAR(1 BYTE),
    CONSTRAINT "PK_AB03B04T00" PRIMARY KEY ("ID_004") USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645 PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT) TABLESPACE "USERS" ENABLE,
	CONSTRAINT "FK_AB03B04T00_AB03B03T00" FOREIGN KEY ("ID_003_CARGO") REFERENCES "AB03B"."AB03B03T00" ("ID_003") ENABLE
  )
  SEGMENT CREATION IMMEDIATE PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING STORAGE
  (
    INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645 PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT
  )
  TABLESPACE "AB0301E00" ;
COMMENT ON COLUMN "AB03B"."AB03B04T00"."ID_004"
IS
  'PK Secuencial de la tabla';
  COMMENT ON COLUMN "AB03B"."AB03B04T00"."NOMBRE_004"
IS
  'Nombre del firmante';
  COMMENT ON COLUMN "AB03B"."AB03B04T00"."APEL1_004"
IS
  'Apellido 1 del firmante';
COMMENT ON COLUMN "AB03B"."AB03B04T00"."APEL2_004"
IS
  'Apellido 2 del firmante';
COMMENT ON COLUMN "AB03B"."AB03B04T00"."ID_003_CARGO"
IS
  'FK a tabla de cargos';    
  COMMENT ON COLUMN "AB03B"."AB03B04T00"."ACTIVO_SN_004"
IS
  'Marca de Activo (S/N)';
  COMMENT ON TABLE "AB03B"."AB03B04T00"
IS
  'Tabla de firmantes';
  
/************************************************************/
CREATE TABLE "AB03B"."AB03B05T00"
  (
    "ID_005"       NUMBER(8,0) NOT NULL ENABLE,
    "NOMBRE_005"   VARCHAR2(150 BYTE),
    "PLANTILLA_005" BLOB,
	"BAJA_005"    CHAR(1 BYTE),
    CONSTRAINT "SYS_C0066001" CHECK ("ID_005" IS NOT NULL) ENABLE,
    CONSTRAINT "PK_AB03B05T00" PRIMARY KEY ("ID_005") USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645 PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT) TABLESPACE "USERS" ENABLE
  )
  SEGMENT CREATION IMMEDIATE PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING STORAGE
  (
    INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645 PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT
  )
  TABLESPACE "AB0301E00" LOB
  (
    "PLANTILLA_005"
  )
  STORE AS BASICFILE
  (
    TABLESPACE "AB0301E00" ENABLE STORAGE IN ROW CHUNK 8192 RETENTION NOCACHE LOGGING STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645 PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  ) ;
COMMENT ON COLUMN "AB03B"."AB03B05T00"."ID_005"
IS
  'PK secuencial de la tabla.';
  COMMENT ON COLUMN "AB03B"."AB03B05T00"."NOMBRE_005"
IS
  'Nombre de la plantilla';
  COMMENT ON COLUMN "AB03B"."AB03B05T00"."PLANTILLA_005"
IS
  'Plantilla';
  COMMENT ON COLUMN "AB03B"."AB03B05T00"."BAJA_005"
IS
  'Indica si una plantilla est de baja: 0-Alta, 1-Baja';
  
  COMMENT ON TABLE "AB03B"."AB03B05T00"
IS
  'Tabla de plantillas';
  
/*******************************************************/  

CREATE TABLE "AB03B"."AB03B06T00"
  (
    "ID_006"      CHAR(1 BYTE) NOT NULL ENABLE,
    "DESC_ES_006" VARCHAR2(150 BYTE),
    "DESC_EU_006" VARCHAR2(150 BYTE),
    CONSTRAINT "PK_AB03B06T00" PRIMARY KEY ("ID_006") USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645 PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT) TABLESPACE "USERS" ENABLE
  )
  SEGMENT CREATION IMMEDIATE PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING STORAGE
  (
    INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645 PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT
  )
  TABLESPACE "AB0301E00" ;
COMMENT ON COLUMN "AB03B"."AB03B06T00"."ID_006"
IS
  'Id de tipo de Modificacion';
  COMMENT ON COLUMN "AB03B"."AB03B06T00"."DESC_ES_006"
IS
  'Modificacion';
  COMMENT ON COLUMN "AB03B"."AB03B06T00"."DESC_EU_006"
IS
  'Descripcion Euskera';
  COMMENT ON TABLE "AB03B"."AB03B06T00"
IS
  'Tipos de acceso ';
  
  
/*********************************************************/  

CREATE TABLE "AB03B"."AB03B07T00"
  (
    "ID_007" VARCHAR2(100 BYTE) NOT NULL ENABLE,
    "DESC_ES_007"   VARCHAR2(150 BYTE),
    "DESC_EU_007"   VARCHAR2(150 BYTE),
    "ID_COD_PADRE"  VARCHAR2(100 BYTE),
    CONSTRAINT "PK_AB03B07T00" PRIMARY KEY ("ID_007") USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645 PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT) TABLESPACE "USERS" ENABLE
  )
  SEGMENT CREATION IMMEDIATE PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING STORAGE
  (
    INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645 PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT
  )
  TABLESPACE "AB0301E00" ;
COMMENT ON COLUMN "AB03B"."AB03B07T00"."ID_007"
IS
  'Identificador de cdigo de documento';
  COMMENT ON COLUMN "AB03B"."AB03B07T00"."DESC_ES_007"
IS
  'Descripcin en Castellano';
  COMMENT ON COLUMN "AB03B"."AB03B07T00"."DESC_EU_007"
IS
  'Descripcin en Euskera';
  COMMENT ON COLUMN "AB03B"."AB03B07T00"."ID_COD_PADRE"
IS
  'ID del padre';
  COMMENT ON TABLE "AB03B"."AB03B07T00"
IS
  'Tabla de tipos/Subtipos de documentos de Dokusi';
/*********************************************************/  

CREATE TABLE "AB03B"."AB03B08T00"
  (
    "ID_008"         NUMBER(8,0) NOT NULL ENABLE,
    "DESC_ES_008"    VARCHAR2(250 BYTE),
    "DESC_EU_008"    VARCHAR2(250 BYTE),
    "COD_PLATEA_008" VARCHAR2(16 BYTE),
    CONSTRAINT "SYS_C0065971" CHECK ("ID_008" IS NOT NULL) ENABLE,
    CONSTRAINT "PK_AB03B08T00" PRIMARY KEY ("ID_008") USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645 PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT) TABLESPACE "USERS" ENABLE
  )
  SEGMENT CREATION IMMEDIATE PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING STORAGE
  (
    INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645 PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT
  )
  TABLESPACE "AB0301E00" ;
COMMENT ON COLUMN "AB03B"."AB03B08T00"."ID_008"
IS
  'Secuencia, clave primaria';
  COMMENT ON COLUMN "AB03B"."AB03B08T00"."DESC_ES_008"
IS
  'Descripcion castellano de tipo de solicitud/plan';
  COMMENT ON COLUMN "AB03B"."AB03B08T00"."DESC_EU_008"
IS
  'Descripcion Euskera de tipo de solicitud/plan';
  COMMENT ON COLUMN "AB03B"."AB03B08T00"."COD_PLATEA_008"
IS
  'Codigo de procedimiento PLATEA';
  COMMENT ON TABLE "AB03B"."AB03B08T00"
IS
  'Tabla de Tipos de solicitud/plan';

/*********************************************************/  
    

CREATE TABLE "AB03B"."AB03B09T00"
  (
    "ID_009"       NUMBER(8,0) NOT NULL ENABLE,
    "ID_008_TIPO_PLAN" NUMBER(8,0),
    "NUMANO_009"   NUMBER(4,0),
    "FLECTURA_009" DATE,
    "JMSID_009"  VARCHAR2(64 BYTE),
    "NUMREG_009" VARCHAR2(32 BYTE),
    "FREGISTRO_009" DATE,
    "MENSAJE_009" CLOB,
    "ID_001_FASE"     NUMBER(8,0),
    "ID_002_TRAMITE"   NUMBER(8,0),
    "REMITENTE_NOM_009" VARCHAR2(250 BYTE),
    "SITUACION_009"     VARCHAR2(1 BYTE),
    "REMITENTE_ID_009"  VARCHAR2(16 BYTE),
    "EXP_RELAC_009"         VARCHAR2(64 BYTE),
	CONSTRAINT "PK_AB03B09T00" PRIMARY KEY ("ID_009") USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645 PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT) TABLESPACE "USERS" ENABLE,
	CONSTRAINT "FK_AB03B09T00_AB03B08T00" FOREIGN KEY ("ID_008_TIPO_PLAN") REFERENCES "AB03B"."AB03B08T00" ("ID_008") ENABLE,
	CONSTRAINT "FK_AB03B09T00_AB03B02T00" FOREIGN KEY ("ID_001_FASE","ID_002_TRAMITE") REFERENCES "AB03B"."AB03B02T00" ("ID_001_FASE", "ID_002") ENABLE
  )
  SEGMENT CREATION IMMEDIATE PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING STORAGE
  (
    INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645 PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT
  )
  TABLESPACE "AB0301E00" LOB
  (
    "MENSAJE_009"
  )
  STORE AS BASICFILE
  (
    TABLESPACE "AB0301E00" ENABLE STORAGE IN ROW CHUNK 8192 RETENTION NOCACHE LOGGING STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645 PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  ) ;
COMMENT ON COLUMN "AB03B"."AB03B09T00"."ID_009"
IS
  'PK de la tabla';
  COMMENT ON COLUMN "AB03B"."AB03B09T00"."ID_008_TIPO_PLAN"
IS
  'Codigo de tipo de PLAN';
  COMMENT ON COLUMN "AB03B"."AB03B09T00"."NUMANO_009"
IS
  'Ao de la peticion';
  COMMENT ON COLUMN "AB03B"."AB03B09T00"."FLECTURA_009"
IS
  'Fecha de lectura';
  COMMENT ON COLUMN "AB03B"."AB03B09T00"."JMSID_009"
IS
  'JMS ID';
  COMMENT ON COLUMN "AB03B"."AB03B09T00"."NUMREG_009"
IS
  'Numero de Registro de Entrada';
  COMMENT ON COLUMN "AB03B"."AB03B09T00"."FREGISTRO_009"
IS
  'Fecha de registro de la solicitud';
  COMMENT ON COLUMN "AB03B"."AB03B09T00"."MENSAJE_009"
IS
  'Mensaje completo enviado.';
  COMMENT ON COLUMN "AB03B"."AB03B09T00"."ID_001_FASE"
IS
  'FK a Fase';
  COMMENT ON COLUMN "AB03B"."AB03B09T00"."ID_002_TRAMITE"
IS
  'FK a Trmite';
  COMMENT ON COLUMN "AB03B"."AB03B09T00"."REMITENTE_NOM_009"
IS
  'Remitente';
  COMMENT ON COLUMN "AB03B"."AB03B09T00"."SITUACION_009"
IS
  'Situacin de la Solicitud:   P: Aceptada V: volcado a AB03B';
  COMMENT ON COLUMN "AB03B"."AB03B09T00"."REMITENTE_ID_009"
IS
  'ID del Remitente';
  COMMENT ON COLUMN "AB03B"."AB03B09T00"."EXP_RELAC_009"
IS
  'Id del expediente Relacionado';
  COMMENT ON TABLE "AB03B"."AB03B09T00"
IS
  'Tabla repositorio para las entradas Telemticas';
 
/****************************************************************/

CREATE TABLE "AB03B"."AB03B10T00"
  (
    "ID_010"          NUMBER(8,0) NOT NULL ENABLE,
    "ID_ANO_010"      NUMBER(4,0) NOT NULL ENABLE,
    "NUM_REG_010"             VARCHAR2(32 BYTE),
    "FEC_REG_010" DATE,
	"NIF_SOLICITANTE_010"     VARCHAR2(150 BYTE),
	"RAZON_SOCIAL_010"      VARCHAR2(200 BYTE),
	"NSS_010"       VARCHAR2(200 BYTE),
	"ID_024_RERA"          NUMBER(8,0) ,
    "ID_ANO_024_RERA"      NUMBER(4,0) ,
    "CALLE_010"               VARCHAR2(250 BYTE),
    "NUM_CALLE_010"           VARCHAR2(150 BYTE),
    "PISO_010"                VARCHAR2(150 BYTE),
    "LETRA_010"               VARCHAR2(25 BYTE),
    "CP_010"                  VARCHAR2(10 BYTE),
    "MUNICIPIO_010"           VARCHAR2(10 BYTE),
    "PROVINCIA_010"           VARCHAR2(10 BYTE),
	"REPRESENTANTE_LEGAL_010"      VARCHAR2(200 BYTE),
	"TELF1_010"       VARCHAR2(50 BYTE),
    "TELF2_010"       VARCHAR2(50 BYTE),
    "EMAIL_010"       VARCHAR2(150 BYTE),
	"IDIOMA_COMUNIC_010"      NUMBER(8,0),
	"PROVINCIA_TRABAJO_010"   VARCHAR2(10 BYTE),
    "MUNICIP_TRABAJO_010"     VARCHAR2(10 BYTE),
    "CALLE_TRABAJO_010"       VARCHAR2(250 BYTE),
    "NUMERO_TRABAJO_010"      VARCHAR2(150 BYTE),
    "PISO_TRABAJO_010"        VARCHAR2(150 BYTE),
    "LETRA_TRABAJO_010"       VARCHAR2(25 BYTE),
    "CPOSTAL_TRABAJO_010"     VARCHAR2(10 BYTE),
	"F_INICIO_TRABAJO_010" DATE,
	"DURACION_DIAS_010" NUMBER(5,0),
	"RESOL_FAVORABLE_010"     NUMBER(1,0),
    "EXP_CERRADO_010"      CHAR(1 BYTE) DEFAULT 'N',
    "NOTIF_LEIDA_010"       CHAR(1 BYTE) DEFAULT 'N' --  Flag para marcar la lectura de la notificacion
    ,
    "REQ_LEIDO_010" CHAR(1 BYTE) DEFAULT 'N',
	"ID_008_TIPO_PLAN"  NUMBER(8,0),
	"EXP_SANC_010"     VARCHAR2(50 BYTE),
	"TECN_ASIGN_010"     VARCHAR2(10 BYTE),
    CONSTRAINT "SYS_C0066005" CHECK ("ID_010" IS NOT NULL) ENABLE,
    CONSTRAINT "PK_AB03B10T00" PRIMARY KEY ("ID_ANO_010", "ID_010") USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645 PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT) TABLESPACE "USERS" ENABLE,
    CONSTRAINT "FK_AB03B10T00_AB03B08T00" FOREIGN KEY ("ID_008_TIPO_PLAN") REFERENCES "AB03B"."AB03B08T00" ("ID_008") ENABLE
  )
  SEGMENT CREATION IMMEDIATE PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING STORAGE
  (
    INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645 PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT
  )
  TABLESPACE "AB0311E00" ;
COMMENT ON COLUMN "AB03B"."AB03B10T00"."ID_010"
IS
  'ID del expediente';
COMMENT ON COLUMN "AB03B"."AB03B10T00"."ID_ANO_010"
IS
  'Ao del expediente';
 COMMENT ON COLUMN "AB03B"."AB03B10T00"."NUM_REG_010"
IS
  'Numero de Registro de entrada';
  COMMENT ON COLUMN "AB03B"."AB03B10T00"."FEC_REG_010"
IS
  'Fecha de Registro del expediente.';  
  COMMENT ON COLUMN "AB03B"."AB03B10T00"."NIF_SOLICITANTE_010"
IS
  'NIF del solicitante';
  COMMENT ON COLUMN "AB03B"."AB03B10T00"."RAZON_SOCIAL_010"
IS
  'Razn social del Solicitante';
  COMMENT ON COLUMN "AB03B"."AB03B10T00"."NSS_010"
IS
  'Nmero de la seguridad social del Solicitante';
COMMENT ON COLUMN "AB03B"."AB03B10T00"."ID_024_RERA"
IS
  'FK tabla 024: Nmero de inscripcin en RERA ';
COMMENT ON COLUMN "AB03B"."AB03B10T00"."ID_ANO_024_RERA"
IS
  'FK tabla 024: Ao de inscripcin en RERA ';
COMMENT ON COLUMN "AB03B"."AB03B10T00"."CALLE_010"
IS
  'Nombre de la calle';
  COMMENT ON COLUMN "AB03B"."AB03B10T00"."NUM_CALLE_010"
IS
  'Numero de portal';
  COMMENT ON COLUMN "AB03B"."AB03B10T00"."PISO_010"
IS
  'Piso de la vivienda';
  COMMENT ON COLUMN "AB03B"."AB03B10T00"."LETRA_010"
IS
  'Letra de la vivienda';
  COMMENT ON COLUMN "AB03B"."AB03B10T00"."CP_010"
IS
  'Codigo Postal';
  COMMENT ON COLUMN "AB03B"."AB03B10T00"."MUNICIPIO_010"
IS
  'Municipio';
  COMMENT ON COLUMN "AB03B"."AB03B10T00"."PROVINCIA_010"
IS
  'Provincia';  
  COMMENT ON COLUMN "AB03B"."AB03B10T00"."REPRESENTANTE_LEGAL_010"
IS
  'Nombre del representante legal ';  
  COMMENT ON COLUMN "AB03B"."AB03B10T00"."TELF1_010"
IS
  'Telefono 1 del Solicitante ';
  COMMENT ON COLUMN "AB03B"."AB03B10T00"."TELF2_010"
IS
  'Telefono 2 del Solicitante';
  COMMENT ON COLUMN "AB03B"."AB03B10T00"."EMAIL_010"
IS
  'email del solicitante ';
  COMMENT ON COLUMN "AB03B"."AB03B10T00"."IDIOMA_COMUNIC_010"
IS
  'Idioma de comunicacion del Solicitante';
  COMMENT ON COLUMN "AB03B"."AB03B10T00"."PROVINCIA_TRABAJO_010"
IS
  'FK a Tabla de Provincias NORA - Provincia donde se va a realizar el trabajo';
  COMMENT ON COLUMN "AB03B"."AB03B10T00"."MUNICIP_TRABAJO_010"
IS
  'FK a tabla de Municipios de NORA  - Municipio donde se va a realizar el trabajo';
  COMMENT ON COLUMN "AB03B"."AB03B10T00"."CALLE_TRABAJO_010"
IS
  'Calle donde se va a realizar el trabajo';
  COMMENT ON COLUMN "AB03B"."AB03B10T00"."NUMERO_TRABAJO_010"
IS
  'Direccion - Numero de la calle donde se va a realizar el trabajo';
  COMMENT ON COLUMN "AB03B"."AB03B10T00"."PISO_TRABAJO_010"
IS
  ' Direccion - Piso donde se va a realizar el trabajo';
  COMMENT ON COLUMN "AB03B"."AB03B10T00"."LETRA_TRABAJO_010"
IS
  'Direccin -  Letra donde se va a realizar el trabajo ';  
 COMMENT ON COLUMN "AB03B"."AB03B10T00"."CPOSTAL_TRABAJO_010"
IS
  'Cdigo Postal donde se va a realizar el trabajo';
COMMENT ON COLUMN "AB03B"."AB03B10T00"."F_INICIO_TRABAJO_010"
IS
  'Fecha de inicio del trabajo ';
  COMMENT ON COLUMN "AB03B"."AB03B10T00"."DURACION_DIAS_010"
IS
  'Duracin del trabajo en das ';
COMMENT ON COLUMN "AB03B"."AB03B10T00"."RESOL_FAVORABLE_010"
IS
  'Resolucion favorable del informe: S: SI N: NO';
COMMENT ON COLUMN "AB03B"."AB03B10T00"."EXP_CERRADO_010"
IS
  'Fecha de inicio del trabajo ';
COMMENT ON COLUMN "AB03B"."AB03B10T00"."NOTIF_LEIDA_010"
 IS
  'Expediente cerrado: S: SI N: NO';
COMMENT ON COLUMN "AB03B"."AB03B10T00"."REQ_LEIDO_010"
IS
  'Requerimiento leido: S: SI N: NO';
COMMENT ON COLUMN "AB03B"."AB03B10T00"."ID_008_TIPO_PLAN" 
IS
  'FK a tabla 8: tipo de plan/solicitud ';
COMMENT ON COLUMN "AB03B"."AB03B10T00"."EXP_SANC_010" 
IS
  'Expediente sancionador ';
COMMENT ON COLUMN "AB03B"."AB03B10T00"."TECN_ASIGN_010" 
IS
  'NIF del Tcnico asignado';  

  COMMENT ON TABLE "AB03B"."AB03B10T00"
IS
  'Tabla de expedientes ';
  
/**************************************************************/

 CREATE TABLE "AB03B"."AB03B11T00"
  (
    "ID_011"          NUMBER(8,0) NOT NULL ENABLE,
    "ID_001_FASE"     NUMBER(8,0),
    "ID_002_TRAMITE"     NUMBER(8,0),
    "ID_008_TIPO_PLAN" NUMBER(8,0),
    "DESC_ES_011"     VARCHAR2(600 BYTE) NOT NULL ENABLE,
    "DESC_EU_011"     VARCHAR2(600 BYTE) NOT NULL ENABLE,
    "ID_007_TP_DOC_DOKUSI" VARCHAR2(100 BYTE),
    "ID_007_ST_DOC_DOKUSI" VARCHAR2(100 BYTE),
    CONSTRAINT "SYS_C0066019" CHECK ("ID_011" IS NOT NULL) ENABLE,
    CONSTRAINT "PK_AB03B11T00" PRIMARY KEY ("ID_011") USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645 PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT) TABLESPACE "USERS" ENABLE,
    CONSTRAINT "FK_AB03B11T00_AB03B02T00" FOREIGN KEY ("ID_001_FASE","ID_002_TRAMITE") REFERENCES "AB03B"."AB03B02T00" ("ID_001_FASE", "ID_002") ENABLE,
	CONSTRAINT "FK_AB03B11T00_AB03B08T00" FOREIGN KEY ("ID_008_TIPO_PLAN") REFERENCES "AB03B"."AB03B08T00" ("ID_008") ENABLE,
	CONSTRAINT "FK_AB03B11T00_AB03B07T00_1" FOREIGN KEY ("ID_007_TP_DOC_DOKUSI") REFERENCES "AB03B"."AB03B07T00" ("ID_007") ENABLE,
	CONSTRAINT "FK_AB03B11T00_AB03B07T00_2" FOREIGN KEY ("ID_007_ST_DOC_DOKUSI") REFERENCES "AB03B"."AB03B07T00" ("ID_007") ENABLE
  )
  SEGMENT CREATION IMMEDIATE PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING STORAGE
  (
    INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645 PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT
  )
  TABLESPACE "AB0301E00" ;
COMMENT ON COLUMN "AB03B"."AB03B11T00"."ID_011"
IS
  'Clave primaria';
  COMMENT ON COLUMN "AB03B"."AB03B11T00"."ID_001_FASE"
IS
  'FK a Tabla de Fases';
  COMMENT ON COLUMN "AB03B"."AB03B11T00"."ID_002_TRAMITE"
IS
  'FK a Tabla de Trmites';
  COMMENT ON COLUMN "AB03B"."AB03B11T00"."ID_008_TIPO_PLAN"
IS
  'FK a Tipos de plan';
  COMMENT ON COLUMN "AB03B"."AB03B11T00"."DESC_ES_011"
IS
  'Descripcin Castellano del Documento';
  COMMENT ON COLUMN "AB03B"."AB03B11T00"."DESC_EU_011"
IS
  'Descripcin Euskera del Documento';
  COMMENT ON COLUMN "AB03B"."AB03B11T00"."ID_007_TP_DOC_DOKUSI"
IS
  'Tipo de Documento de dokusi';
  COMMENT ON COLUMN "AB03B"."AB03B11T00"."ID_007_ST_DOC_DOKUSI"
IS
  'SubTipo de Documento de Dokusi';
 
  COMMENT ON TABLE "AB03B"."AB03B11T00"
IS
  'Documentacin de Solictudes';
  
/*******************************************************************/

CREATE TABLE "AB03B"."AB03B12T00"
  (
    "ID_012"  NUMBER(8,0),
    "DESC_ES_012"    VARCHAR2(150 BYTE),
    "DESC_EU_012"    VARCHAR2(150 BYTE),
    "ID_009_CODJMS"     NUMBER(8,0),
    "META_INF_012"   VARCHAR2(640 BYTE),
	"ID_011_DOC_SOL"    	 NUMBER(8,0),
    CONSTRAINT "PK_AB03B12T00" PRIMARY KEY ("ID_012") USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645 PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT) TABLESPACE "USERS" ENABLE,
    CONSTRAINT "FK_AB03B12T00_AB03B09T00" FOREIGN KEY ("ID_009_CODJMS") REFERENCES "AB03B"."AB03B09T00" ("ID_009") ENABLE,
	CONSTRAINT "FK_AB03B12T00_AB03B11T00" FOREIGN KEY ("ID_011_DOC_SOL") REFERENCES "AB03B"."AB03B11T00" ("ID_011") ENABLE
 
  )
  SEGMENT CREATION IMMEDIATE PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING STORAGE
  (
    INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645 PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT
  )
  TABLESPACE "AB0301E00" ;
COMMENT ON COLUMN "AB03B"."AB03B12T00"."ID_012"
IS
  'OID del Documento';
  COMMENT ON COLUMN "AB03B"."AB03B12T00"."DESC_ES_012"
IS
  'Descripcin en castellano';
  COMMENT ON COLUMN "AB03B"."AB03B12T00"."DESC_EU_012"
IS
  'Descripcin en Euskera';
  COMMENT ON COLUMN "AB03B"."AB03B12T00"."ID_009_CODJMS"
IS
  'FK a la tabla 009 (Codigo de Solicitud Telemtica JMS)';
  COMMENT ON COLUMN "AB03B"."AB03B12T00"."META_INF_012"
IS
  'Metainformacin del documento';
 COMMENT ON COLUMN "AB03B"."AB03B12T00"."ID_011_DOC_SOL"
IS
  'FK a la tabla 011: ID del documento de solicitudes';  
  COMMENT ON TABLE "AB03B"."AB03B12T00"
IS
  'Tabla de OIDs Dokusi de entrada Telemtica';  
  
/***************************************************************/

CREATE TABLE "AB03B"."AB03B13T00"
  (
    "ID_013"           NUMBER(8,0) NOT NULL ENABLE,
    "ID_001_FASE"      NUMBER(8,0),
    "ID_002_TRAMITE"   NUMBER(8,0),
    "DESC_ES_013"      VARCHAR2(400 BYTE),
    "DESC_EU_013"      VARCHAR2(400 BYTE),
	"ID_005_PLANTILLA"       NUMBER(8,0),
    "ID_007_TP_DOC_DOKUSI" VARCHAR2(100 BYTE),
    "ID_007_ST_DOC_DOKUSI" VARCHAR2(100 BYTE),
    CONSTRAINT "PK_AB03B13T00" PRIMARY KEY ("ID_013") USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645 PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT) TABLESPACE "USERS" ENABLE,
    CONSTRAINT "FK_AB03B13T00_AB03B02T00" FOREIGN KEY ("ID_001_FASE","ID_002_TRAMITE") REFERENCES "AB03B"."AB03B02T00" ("ID_001_FASE", "ID_002") ENABLE,
	CONSTRAINT "FK_AB03B13T00_AB03B05T00" FOREIGN KEY ("ID_005_PLANTILLA") REFERENCES "AB03B"."AB03B05T00" ("ID_005") ENABLE,
	CONSTRAINT "FK_AB03B13T00_AB03B07T00_1" FOREIGN KEY ("ID_007_TP_DOC_DOKUSI") REFERENCES "AB03B"."AB03B07T00" ("ID_007") ENABLE,
	CONSTRAINT "FK_AB03B13T00_AB03B07T00_2" FOREIGN KEY ("ID_007_ST_DOC_DOKUSI") REFERENCES "AB03B"."AB03B07T00" ("ID_007") ENABLE
  )
  SEGMENT CREATION IMMEDIATE PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING STORAGE
  (
    INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645 PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT
  )
   ;
COMMENT ON COLUMN "AB03B"."AB03B13T00"."ID_013"
IS
  'PK Secuencia de la tabla';
  COMMENT ON COLUMN "AB03B"."AB03B13T00"."ID_001_FASE"
IS
  'FK a Tabla de Fases';
  COMMENT ON COLUMN "AB03B"."AB03B13T00"."ID_002_TRAMITE"
IS
  'FK a Tabla de Trmites ';
 
  COMMENT ON COLUMN "AB03B"."AB03B13T00"."DESC_ES_013"
IS
  'Descripcin Castellano del Documento';
  COMMENT ON COLUMN "AB03B"."AB03B13T00"."DESC_EU_013"
IS
  'Descripcin Euskera del Documento ';
  COMMENT ON COLUMN "AB03B"."AB03B13T00"."ID_005_PLANTILLA"
IS
  'FK a tabla 5: ID de la plantilla';
 
  COMMENT ON COLUMN "AB03B"."AB03B13T00"."ID_007_TP_DOC_DOKUSI"
IS
  'Tipo de Documento de Dokusi';
  COMMENT ON COLUMN "AB03B"."AB03B13T00"."ID_007_ST_DOC_DOKUSI"
IS
  'SubTipo de Docuento de Dokusi';
  COMMENT ON TABLE "AB03B"."AB03B13T00"
IS
  'Tabla de Tipos de Documentos de Expedientes';  
  
/************************************************************************/
CREATE TABLE "AB03B"."AB03B14T00"
  (
    "ID_014"          NUMBER(8,0) NOT NULL ENABLE,
    "ID_001_FASE"     NUMBER(8,0),
    "ID_002_TRAMITE"     NUMBER(8,0),
    "ID_010_NUM_EXP"  NUMBER(8,0),
    "ID_ANO_010"      NUMBER(4,0),
    "F_ACTU_014" DATE,
    "USUA_014" VARCHAR2(120 BYTE),
    "F_REG_SAL_014" DATE,
    "N_REG_SAL_014" DATE,
    "F_NOTIF_014" DATE,
    "F_EXPIR_014" DATE,
    "F_MODIF_014" DATE,
    "USU_MOD_014" VARCHAR2(120 BYTE),
    "F_TRAMITACION_014" DATE,
    CONSTRAINT "PK_AB03B14T00" PRIMARY KEY ("ID_014") USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645 PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT) TABLESPACE "USERS" ENABLE,
    CONSTRAINT "FK_AB03B14T00_AB03B02T00" FOREIGN KEY ("ID_001_FASE","ID_002_TRAMITE") REFERENCES "AB03B"."AB03B02T00" ("ID_001_FASE", "ID_002") ENABLE,
	CONSTRAINT "FK_AB03B14T00_AB03B10T00" FOREIGN KEY ("ID_ANO_010", "ID_010_NUM_EXP") REFERENCES "AB03B"."AB03B10T00" ("ID_ANO_010", "ID_010") ENABLE
  )
  SEGMENT CREATION IMMEDIATE PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING STORAGE
  (
    INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645 PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT
  )
  TABLESPACE "AB0301E00" ;
COMMENT ON COLUMN "AB03B"."AB03B14T00"."ID_014"
IS
  'Secuencia - clave primaria de la tabla 14';
  COMMENT ON COLUMN "AB03B"."AB03B14T00"."ID_001_FASE"
IS
  'FK a tabla de Fases';
  COMMENT ON COLUMN "AB03B"."AB03B14T00"."ID_002_TRAMITE"
IS
  'FK a Tabla de Trmites';
  COMMENT ON COLUMN "AB03B"."AB03B14T00"."ID_010_NUM_EXP"
IS
  'FK a tabla de expedientes';
  COMMENT ON COLUMN "AB03B"."AB03B14T00"."ID_ANO_010"
IS
  'Ao del expediente';
  COMMENT ON COLUMN "AB03B"."AB03B14T00"."F_ACTU_014"
IS
  'Fecha de actualizacin del estado';
  COMMENT ON COLUMN "AB03B"."AB03B14T00"."USUA_014"
IS
  'Usuario de actualizacin';
  COMMENT ON COLUMN "AB03B"."AB03B14T00"."F_REG_SAL_014"
IS
  'Fecha de salida del registro';
  COMMENT ON COLUMN "AB03B"."AB03B14T00"."N_REG_SAL_014"
IS
  'Nmero de registro de salida';
  COMMENT ON COLUMN "AB03B"."AB03B14T00"."F_NOTIF_014"
IS
  'Fecha de Notificacin';
  COMMENT ON COLUMN "AB03B"."AB03B14T00"."F_EXPIR_014"
IS
  'Fecha de expiracin de la notificacin';
  COMMENT ON COLUMN "AB03B"."AB03B14T00"."F_MODIF_014"
IS
  'Fecha de Modificacin';
  COMMENT ON COLUMN "AB03B"."AB03B14T00"."USU_MOD_014"
IS
  'Usuario de modificacin';
  COMMENT ON COLUMN "AB03B"."AB03B14T00"."F_TRAMITACION_014"
IS
  'Fecha de tramitacin';
  COMMENT ON TABLE "AB03B"."AB03B14T00"
IS
  'Historial de Tramitacin de un expediente';
/******************************************************************/
CREATE TABLE "AB03B"."AB03B15T00"
  (
    "ID_015"            NUMBER(8,0) NOT NULL ENABLE,
    "ID_010_NUM_EXP"    NUMBER(8,0),
    "ID_ANO_010"        NUMBER(4,0),
    "ID_013_TIPO_DOC_G" NUMBER(8,0),
    "ID_014_HISTO_TRAM" NUMBER(8,0),
    "ID_PIF_015"        VARCHAR2(128 BYTE),
    "ID_012_OID"        NUMBER(8,0),
    CONSTRAINT "PK_AB03B15T00" PRIMARY KEY ("ID_015") USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645 PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT) TABLESPACE "USERS" ENABLE,
    CONSTRAINT "FK_AB03B15T00_AB03B10T00" FOREIGN KEY ("ID_ANO_010", "ID_010_NUM_EXP") REFERENCES "AB03B"."AB03B10T00" ("ID_ANO_010", "ID_010") ENABLE,
    CONSTRAINT "FK_AB03B15T00_AB03B13T00" FOREIGN KEY ("ID_013_TIPO_DOC_G") REFERENCES "AB03B"."AB03B13T00" ("ID_013") ENABLE,
    CONSTRAINT "FK_AB03B15T00_AB03B14T00" FOREIGN KEY ("ID_014_HISTO_TRAM") REFERENCES "AB03B"."AB03B14T00" ("ID_014") ENABLE,
    CONSTRAINT "FK_AB03B15T00_AB03B12T00" FOREIGN KEY ("ID_012_OID") REFERENCES "AB03B"."AB03B12T00" ("ID_012") ENABLE
  )
  SEGMENT CREATION IMMEDIATE PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING STORAGE
  (
    INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645 PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT
  )
  TABLESPACE "AB0301E00";
COMMENT ON COLUMN "AB03B"."AB03B15T00"."ID_015"
IS
  'PF Secuencial de la tabla';
  COMMENT ON COLUMN "AB03B"."AB03B15T00"."ID_010_NUM_EXP"
IS
  'FK a Tabla de Expedientes ';
  COMMENT ON COLUMN "AB03B"."AB03B15T00"."ID_013_TIPO_DOC_G"
IS
  'FK a Tipos de Documentacin Generada';
  COMMENT ON COLUMN "AB03B"."AB03B15T00"."ID_014_HISTO_TRAM"
IS
  'FK a Historial de Tramitacin';
  COMMENT ON COLUMN "AB03B"."AB03B15T00"."ID_PIF_015"
IS
  'Identificador del Documeto en PIF';
  COMMENT ON COLUMN "AB03B"."AB03B15T00"."ID_012_OID"
IS
  'FK a OID del Documento en Dokusi';
  COMMENT ON TABLE "AB03B"."AB03B15T00"
IS
  'Documentacin de expedientes ';
  
  

  
/***********************************************************************/


CREATE TABLE "AB03B"."AB03B16T00"
  (
    "ID_016"          NUMBER(8,0) NOT NULL ENABLE,
    "ID_010_NUM_EXP"  NUMBER(8,0),
    "ID_ANO_010"      NUMBER(4,0),
    "ID_006_TP_ACCESO"  CHAR(1 BYTE),
    "F_ACTU_016" DATE,
    "USU_MODIF_016" VARCHAR2(150 BYTE),
    CONSTRAINT "SYS_C0065977" CHECK ("F_ACTU_016" IS NOT NULL) ENABLE,
    CONSTRAINT "SYS_C0065974" CHECK ("ID_016"     IS NOT NULL) ENABLE,
    CONSTRAINT "PK_AB03B16T00" PRIMARY KEY ("ID_016") USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645 PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT) TABLESPACE "USERS" ENABLE,
    CONSTRAINT "FK_AB03B16T00_AB03B10T00" FOREIGN KEY ("ID_ANO_010", "ID_010_NUM_EXP") REFERENCES "AB03B"."AB03B10T00" ("ID_ANO_010", "ID_010") ENABLE,
    CONSTRAINT "FK_AB03B16T00_AB03B06T00" FOREIGN KEY ("ID_006_TP_ACCESO") REFERENCES "AB03B"."AB03B06T00" ("ID_006") ENABLE
  )
  SEGMENT CREATION IMMEDIATE PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING STORAGE
  (
    INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645 PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT
  )
  TABLESPACE "AB0301E00" ;
COMMENT ON COLUMN "AB03B"."AB03B16T00"."ID_016"
IS
  'Secuencia - Clave primaria de tabla AB03B16T00';

  COMMENT ON COLUMN "AB03B"."AB03B16T00"."ID_010_NUM_EXP"
IS
  'FK a Tabla de expedientes';
  COMMENT ON COLUMN "AB03B"."AB03B16T00"."ID_ANO_010"
IS
  'FK tabla de expedientes - Ao del expediente';
  COMMENT ON COLUMN "AB03B"."AB03B16T00"."ID_006_TP_ACCESO"
IS
  'FK a Tipo de Acceso';
  COMMENT ON COLUMN "AB03B"."AB03B16T00"."F_ACTU_016"
IS
  'Fecha de Actualizacin del resgistro';
  COMMENT ON COLUMN "AB03B"."AB03B16T00"."USU_MODIF_016"
IS
  'Usuario de acceso al resgistro';
  COMMENT ON TABLE "AB03B"."AB03B16T00"
IS
  'Tabla de Accesos a Expedientes';
  
/****************************************************/

  
/*********************************************/  

COMMIT;  

CREATE TABLE "AB03B"."AB03B17T00"
  (
    "ID_017"      NUMBER(8,0) NOT NULL ENABLE,
    "DESC_ES_017" VARCHAR2(250 BYTE),
    "DESC_EU_017" VARCHAR2(250 BYTE),
    CONSTRAINT "SYS_C0066115" CHECK ("ID_017" IS NOT NULL) ENABLE,
    CONSTRAINT "PK_AB03BT017" PRIMARY KEY ("ID_017") USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645 PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT) TABLESPACE "USERS" ENABLE
  )
  SEGMENT CREATION IMMEDIATE PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING STORAGE
  (
    INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645 PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT
  )
  TABLESPACE "AB0301E00" ;
COMMENT ON COLUMN "AB03B"."AB03B17T00"."ID_017"
IS
  'Secuencia, clave primaria de la tabla';
  COMMENT ON COLUMN "AB03B"."AB03B17T00"."DESC_ES_017"
IS
  'Descripcion en castellano de la Fase RERA';
  COMMENT ON COLUMN "AB03B"."AB03B17T00"."DESC_EU_017"
IS
  'Descripcion en euskera de la Fase  RERA';
  COMMENT ON TABLE "AB03B"."AB03B17T00"
IS
  'Tabla de Fases de RERA';
  
  /*********************************************************/
  
  CREATE TABLE "AB03B"."AB03B18T00"
  (
    "ID_018"          NUMBER(8,0) NOT NULL ENABLE,
    "ID_017_FASE"     NUMBER(8,0) NOT NULL ENABLE,
    "DESC_ES_018"     VARCHAR2(200 BYTE),
    "DESC_EU_018"     VARCHAR2(200 BYTE),
    CONSTRAINT "PK_AB03B18T00" PRIMARY KEY ("ID_017_FASE", "ID_018") USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645 PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT) TABLESPACE "USERS" ENABLE,
    CONSTRAINT "FK_AB03B18T00_AB03B17T00" FOREIGN KEY ("ID_017_FASE") REFERENCES "AB03B"."AB03B17T00" ("ID_017") ENABLE
  )
  SEGMENT CREATION IMMEDIATE PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING STORAGE
  (
    INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645 PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT
  )
  TABLESPACE "AB0301E00" ;
COMMENT ON COLUMN "AB03B"."AB03B18T00"."ID_018"
IS
  'Secuencia PK de la tabla de tramites';
  COMMENT ON COLUMN "AB03B"."AB03B18T00"."ID_017_FASE"
IS
  'FK a tabla de Fases RERA';
  COMMENT ON COLUMN "AB03B"."AB03B18T00"."DESC_ES_018"
IS
  'Descripcin en castellano del Tramite RERA';
  COMMENT ON COLUMN "AB03B"."AB03B18T00"."DESC_EU_018"
IS
  'Descripcion en Euskera del Tramite RERA';
  COMMENT ON TABLE "AB03B"."AB03B18T00"
IS
  'Tabla de trmites de RERA';
  
/************************************************************/
CREATE TABLE "AB03B"."AB03B19T00"
  (
    "ID_019"        NUMBER(8,0) NOT NULL ENABLE,
    "DESC_ES_019"   VARCHAR2(150 BYTE),
    "DESC_EU_019"   VARCHAR2(150 BYTE),
    "ACTIVO_SN_019" CHAR(1 BYTE),
    CONSTRAINT "PK_AB03B19T00" PRIMARY KEY ("ID_019") USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645 PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT) TABLESPACE "USERS" ENABLE
  )
  SEGMENT CREATION IMMEDIATE PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING STORAGE
  (
    INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645 PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT
  )
  TABLESPACE "AB0301E00" ;
COMMENT ON COLUMN "AB03B"."AB03B19T00"."ID_019"
IS
  'PK Secuencial de la tabla';
  COMMENT ON COLUMN "AB03B"."AB03B19T00"."DESC_ES_019"
IS
  'Descripcion en Castellano del Cargo RERA';
  COMMENT ON COLUMN "AB03B"."AB03B19T00"."DESC_EU_019"
IS
  'Descripcion Euskera del cargo RERA';
  COMMENT ON COLUMN "AB03B"."AB03B19T00"."ACTIVO_SN_019"
IS
  'Marca de Activo (S/N)';
  COMMENT ON TABLE "AB03B"."AB03B19T00"
IS
  'Tabla de Cargos de RERA';

/************************************************************/
CREATE TABLE "AB03B"."AB03B20T00"
  (
    "ID_020"        NUMBER(8,0) NOT NULL ENABLE,
    "NOMBRE_020"   VARCHAR2(150 BYTE),
    "APEL1_020"    VARCHAR2(150 BYTE),
    "APEL2_020"    VARCHAR2(150 BYTE),    
	"ID_019_CARGO"        NUMBER(8,0) NOT NULL ENABLE,
    "ACTIVO_SN_020" CHAR(1 BYTE),
    CONSTRAINT "PK_AB03B20T00" PRIMARY KEY ("ID_020") USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645 PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT) TABLESPACE "USERS" ENABLE,
	CONSTRAINT "FK_AB03B20T00_AB03B19T00" FOREIGN KEY ("ID_019_CARGO") REFERENCES "AB03B"."AB03B19T00" ("ID_019") ENABLE
  )
  SEGMENT CREATION IMMEDIATE PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING STORAGE
  (
    INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645 PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT
  )
  TABLESPACE "AB0301E00" ;
COMMENT ON COLUMN "AB03B"."AB03B20T00"."ID_020"
IS
  'PK Secuencial de la tabla';
  COMMENT ON COLUMN "AB03B"."AB03B20T00"."NOMBRE_020"
IS
  'Nombre del firmante RERA';
  COMMENT ON COLUMN "AB03B"."AB03B20T00"."APEL1_020"
IS
  'Apellido 1 del firmante RERA';
COMMENT ON COLUMN "AB03B"."AB03B20T00"."APEL2_020"
IS
  'Apellido 2 del firmante RERA';
COMMENT ON COLUMN "AB03B"."AB03B20T00"."ID_019_CARGO"
IS
  'FK a tabla de cargos RERA';    
  COMMENT ON COLUMN "AB03B"."AB03B20T00"."ACTIVO_SN_020"
IS
  'Marca de Activo (S/N)';
  COMMENT ON TABLE "AB03B"."AB03B20T00"
IS
  'Tabla de firmantes de RERA';
  
/************************************************************/
CREATE TABLE "AB03B"."AB03B21T00"
  (
    "ID_021"       NUMBER(8,0) NOT NULL ENABLE,
    "NOMBRE_021"   VARCHAR2(150 BYTE),
    "PLANTILLA_021" BLOB,
	"BAJA_021"    CHAR(1 BYTE),
    CONSTRAINT "SYS_C0066315" CHECK ("ID_021" IS NOT NULL) ENABLE,
    CONSTRAINT "PK_AB03B21T00" PRIMARY KEY ("ID_021") USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645 PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT) TABLESPACE "USERS" ENABLE
  )
  SEGMENT CREATION IMMEDIATE PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING STORAGE
  (
    INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645 PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT
  )
  TABLESPACE "AB0301E00" LOB
  (
    "PLANTILLA_021"
  )
  STORE AS BASICFILE
  (
    TABLESPACE "AB0301E00" ENABLE STORAGE IN ROW CHUNK 8192 RETENTION NOCACHE LOGGING STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645 PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  ) ;
COMMENT ON COLUMN "AB03B"."AB03B21T00"."ID_021"
IS
  'PK secuencial de la tabla.';
  COMMENT ON COLUMN "AB03B"."AB03B21T00"."NOMBRE_021"
IS
  'Nombre de la plantilla RERA';
  COMMENT ON COLUMN "AB03B"."AB03B21T00"."PLANTILLA_021"
IS
  'Plantilla RERA';
  COMMENT ON COLUMN "AB03B"."AB03B21T00"."BAJA_021"
IS
  'Indica si una plantilla est de baja: 0-Alta, 1-Baja';
  
  COMMENT ON TABLE "AB03B"."AB03B21T00"
IS
  'Tabla de plantillas de RERA';
  
/*******************************************************/  


CREATE TABLE "AB03B"."AB03B22T00"
  (
    "ID_022"         NUMBER(8,0) NOT NULL ENABLE,
    "DESC_ES_022"    VARCHAR2(250 BYTE),
    "DESC_EU_022"    VARCHAR2(250 BYTE),
    "COD_PLATEA_022" VARCHAR2(16 BYTE),
    CONSTRAINT "SYS_C0066316" CHECK ("ID_022" IS NOT NULL) ENABLE,
    CONSTRAINT "PK_AB03B22T00" PRIMARY KEY ("ID_022") USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645 PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT) TABLESPACE "USERS" ENABLE
  )
  SEGMENT CREATION IMMEDIATE PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING STORAGE
  (
    INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645 PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT
  )
  TABLESPACE "AB0301E00" ;
COMMENT ON COLUMN "AB03B"."AB03B22T00"."ID_022"
IS
  'Secuencia, clave primaria';
  COMMENT ON COLUMN "AB03B"."AB03B22T00"."DESC_ES_022"
IS
  'Descripcion castellano de tipo de solicitud RERA';
  COMMENT ON COLUMN "AB03B"."AB03B22T00"."DESC_EU_022"
IS
  'Descripcion Euskera de tipo de solicitud RERA';
  COMMENT ON COLUMN "AB03B"."AB03B22T00"."COD_PLATEA_022"
IS
  'Codigo de procedimiento PLATEA';
  COMMENT ON TABLE "AB03B"."AB03B22T00"
IS
  'Tabla de Tipos de solicitudes RERA';

/*********************************************************/  
    

CREATE TABLE "AB03B"."AB03B23T00"
  (
    "ID_023"       NUMBER(8,0) NOT NULL ENABLE,
    "ID_022_TIPO_PLAN" NUMBER(8,0),
    "NUMANO_023"   NUMBER(4,0),
    "FLECTURA_023" DATE,
    "JMSID_023"  VARCHAR2(64 BYTE),
    "NUMREG_023" VARCHAR2(32 BYTE),
    "FREGISTRO_023" DATE,
    "MENSAJE_023" CLOB,
    "ID_017_FASE"     NUMBER(8,0),
    "ID_018_TRAMITE"   NUMBER(8,0),
    "REMITENTE_NOM_023" VARCHAR2(250 BYTE),
    "SITUACION_023"     VARCHAR2(1 BYTE),
    "REMITENTE_ID_023"  VARCHAR2(16 BYTE),
    "EXP_RELAC_023"         VARCHAR2(64 BYTE),
	CONSTRAINT "PK_AB03B23T00" PRIMARY KEY ("ID_023") USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645 PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT) TABLESPACE "USERS" ENABLE,
	CONSTRAINT "FK_AB03B23T00_AB03B22T00" FOREIGN KEY ("ID_022_TIPO_PLAN") REFERENCES "AB03B"."AB03B22T00" ("ID_022") ENABLE,
	CONSTRAINT "FK_AB03B23T00_AB03B18T00" FOREIGN KEY ("ID_017_FASE","ID_018_TRAMITE") REFERENCES "AB03B"."AB03B18T00" ("ID_017_FASE", "ID_018") ENABLE
  )
  SEGMENT CREATION IMMEDIATE PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING STORAGE
  (
    INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645 PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT
  )
  TABLESPACE "AB0301E00" LOB
  (
    "MENSAJE_023"
  )
  STORE AS BASICFILE
  (
    TABLESPACE "AB0301E00" ENABLE STORAGE IN ROW CHUNK 8192 RETENTION NOCACHE LOGGING STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645 PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  ) ;
COMMENT ON COLUMN "AB03B"."AB03B23T00"."ID_023"
IS
  'PK de la tabla';
  COMMENT ON COLUMN "AB03B"."AB03B23T00"."ID_022_TIPO_PLAN"
IS
  'Codigo de tipo de solicitud RERA';
  COMMENT ON COLUMN "AB03B"."AB03B23T00"."NUMANO_023"
IS
  'Ao de la peticion';
  COMMENT ON COLUMN "AB03B"."AB03B23T00"."FLECTURA_023"
IS
  'Fecha de lectura';
  COMMENT ON COLUMN "AB03B"."AB03B23T00"."JMSID_023"
IS
  'JMS ID';
  COMMENT ON COLUMN "AB03B"."AB03B23T00"."NUMREG_023"
IS
  'Numero de Registro de Entrada';
  COMMENT ON COLUMN "AB03B"."AB03B23T00"."FREGISTRO_023"
IS
  'Fecha de registro de la solicitud';
  COMMENT ON COLUMN "AB03B"."AB03B23T00"."MENSAJE_023"
IS
  'Mensaje completo enviado.';
  COMMENT ON COLUMN "AB03B"."AB03B23T00"."ID_017_FASE"
IS
  'FK a Fase RERA';
  COMMENT ON COLUMN "AB03B"."AB03B23T00"."ID_018_TRAMITE"
IS
  'FK a Trmite RERA ';
  COMMENT ON COLUMN "AB03B"."AB03B23T00"."REMITENTE_NOM_023"
IS
  'Remitente';
  COMMENT ON COLUMN "AB03B"."AB03B23T00"."SITUACION_023"
IS
  'Situacin de la Solicitud RERA:   P: Aceptada V: volcado a AB03B';
  COMMENT ON COLUMN "AB03B"."AB03B23T00"."REMITENTE_ID_023"
IS
  'ID del Remitente';
  COMMENT ON COLUMN "AB03B"."AB03B23T00"."EXP_RELAC_023"
IS
  'Id del expediente RERA Relacionado';
  COMMENT ON TABLE "AB03B"."AB03B23T00"
IS
  'Tabla repositorio para las entradas Telemticas de RERA';
 
/****************************************************************/

CREATE TABLE "AB03B"."AB03B24T00"
  (
    "ID_024"          NUMBER(8,0) NOT NULL ENABLE,
    "ID_ANO_024"      NUMBER(4,0) NOT NULL ENABLE,
    "NUM_REG_024"             VARCHAR2(32 BYTE),
    "FEC_REG_024" DATE,
	"NIF_EMPRESA_024"     VARCHAR2(150 BYTE),
	"RAZON_SOCIAL_024"      VARCHAR2(200 BYTE),
	"NSS_024"       VARCHAR2(200 BYTE),
    "CALLE_024"               VARCHAR2(250 BYTE),
    "NUM_CALLE_024"           VARCHAR2(150 BYTE),
    "PISO_024"                VARCHAR2(150 BYTE),
    "LETRA_024"               VARCHAR2(25 BYTE),
    "CP_024"                  VARCHAR2(10 BYTE),
    "MUNICIPIO_024"           VARCHAR2(10 BYTE),
    "PROVINCIA_024"           VARCHAR2(10 BYTE),
	"REPRESENTANTE_LEGAL_024"      VARCHAR2(200 BYTE),
	"TELF1_024"       VARCHAR2(50 BYTE),
    "TELF2_024"       VARCHAR2(50 BYTE),
    "EMAIL_024"       VARCHAR2(150 BYTE),
	"IDIOMA_COMUNIC_024"      NUMBER(8,0),
	"INSCRIPCION_FAVORABLE_024"     NUMBER(1,0),
    "EXP_CERRADO_024"      CHAR(1 BYTE) DEFAULT 'N',
    "NOTIF_LEIDA_024"       CHAR(1 BYTE) DEFAULT 'N' --  Flag para marcar la lectura de la notificacion
    ,
    "REQ_LEIDO_024" CHAR(1 BYTE) DEFAULT 'N',
	"ID_022_TIPO_PLAN"  NUMBER(8,0),
	"CAMBIO_ESTATUTOS_024"      CHAR(1 BYTE) DEFAULT 'N',
	"ESTADO_EMPRESA_024"    CHAR(1 BYTE) DEFAULT '0',
	"F_CAMBIO_ESTADO_024"   DATE,
    CONSTRAINT "SYS_C0066317" CHECK ("ID_024" IS NOT NULL) ENABLE,
    CONSTRAINT "PK_AB03B24T00" PRIMARY KEY ("ID_ANO_024", "ID_024") USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645 PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT) TABLESPACE "USERS" ENABLE,
    CONSTRAINT "FK_AB03B24T00_AB03B22T00" FOREIGN KEY ("ID_022_TIPO_PLAN") REFERENCES "AB03B"."AB03B22T00" ("ID_022") ENABLE
  )
  SEGMENT CREATION IMMEDIATE PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING STORAGE
  (
    INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645 PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT
  )
  TABLESPACE "AB0311E00" ;
COMMENT ON COLUMN "AB03B"."AB03B24T00"."ID_024"
IS
  'ID del expediente';
COMMENT ON COLUMN "AB03B"."AB03B24T00"."ID_ANO_024"
IS
  'Ao del expediente';
 COMMENT ON COLUMN "AB03B"."AB03B24T00"."NUM_REG_024"
IS
  'Numero de Registro de entrada';
  COMMENT ON COLUMN "AB03B"."AB03B24T00"."FEC_REG_024"
IS
  'Fecha de Registro del expediente.';  
  COMMENT ON COLUMN "AB03B"."AB03B24T00"."NIF_EMPRESA_024"
IS
  'NIF de la empresa que solicita darse de alta';
  COMMENT ON COLUMN "AB03B"."AB03B24T00"."RAZON_SOCIAL_024"
IS
  'Razn social del Solicitante';
  COMMENT ON COLUMN "AB03B"."AB03B24T00"."NSS_024"
IS
  'Nmero de la seguridad social del Solicitante';
COMMENT ON COLUMN "AB03B"."AB03B24T00"."CALLE_024"
IS
  'Nombre de la calle';
  COMMENT ON COLUMN "AB03B"."AB03B24T00"."NUM_CALLE_024"
IS
  'Numero de portal';
  COMMENT ON COLUMN "AB03B"."AB03B24T00"."PISO_024"
IS
  'Piso de la vivienda';
  COMMENT ON COLUMN "AB03B"."AB03B24T00"."LETRA_024"
IS
  'Letra de la vivienda';
  COMMENT ON COLUMN "AB03B"."AB03B24T00"."CP_024"
IS
  'Codigo Postal';
  COMMENT ON COLUMN "AB03B"."AB03B24T00"."MUNICIPIO_024"
IS
  'Municipio';
  COMMENT ON COLUMN "AB03B"."AB03B24T00"."PROVINCIA_024"
IS
  'Provincia';  
  COMMENT ON COLUMN "AB03B"."AB03B24T00"."REPRESENTANTE_LEGAL_024"
IS
  'Nombre del representante legal ';  
  COMMENT ON COLUMN "AB03B"."AB03B24T00"."TELF1_024"
IS
  'Telefono 1 del Solicitante ';
  COMMENT ON COLUMN "AB03B"."AB03B24T00"."TELF2_024"
IS
  'Telefono 2 del Solicitante';
  COMMENT ON COLUMN "AB03B"."AB03B24T00"."EMAIL_024"
IS
  'email del solicitante ';
  COMMENT ON COLUMN "AB03B"."AB03B24T00"."IDIOMA_COMUNIC_024"
IS
  'Idioma de comunicacion del Solicitante';
COMMENT ON COLUMN "AB03B"."AB03B24T00"."INSCRIPCION_FAVORABLE_024"
IS
  'Inscripcin favorable de la empresa: S: SI N: NO';
COMMENT ON COLUMN "AB03B"."AB03B24T00"."EXP_CERRADO_024"
IS
  'Fecha de inicio del trabajo ';
COMMENT ON COLUMN "AB03B"."AB03B24T00"."NOTIF_LEIDA_024"
 IS
  'Expediente cerrado: S: SI N: NO';
COMMENT ON COLUMN "AB03B"."AB03B24T00"."REQ_LEIDO_024"
IS
  'Requerimiento leido: S: SI N: NO';
COMMENT ON COLUMN "AB03B"."AB03B24T00"."ID_022_TIPO_PLAN" 
IS
  'FK a tabla 22: tipo de plan RERA ';
COMMENT ON COLUMN "AB03B"."AB03B24T00"."CAMBIO_ESTATUTOS_024" 
IS
  'Indica si la empresa ha tenido cambios en sus estatutos S: SI N: NO';
COMMENT ON COLUMN "AB03B"."AB03B24T00"."ESTADO_EMPRESA_024" 
IS
  'Estado de la empresa en RERA: 0-Alta 1-Baja';  
COMMENT ON COLUMN "AB03B"."AB03B24T00"."F_CAMBIO_ESTADO_024" 
IS
  'Fecha de cambio de la empresa (alta/baja)';  
  COMMENT ON TABLE "AB03B"."AB03B24T00"
IS
  'Tabla de expedientes RERA';
  
/**************************************************************/

 CREATE TABLE "AB03B"."AB03B25T00"
  (
    "ID_025"          NUMBER(8,0) NOT NULL ENABLE,
    "ID_017_FASE"     NUMBER(8,0),
    "ID_018_TRAMITE"     NUMBER(8,0),
    "ID_022_TIPO_PLAN" NUMBER(8,0),
    "DESC_ES_025"     VARCHAR2(600 BYTE) NOT NULL ENABLE,
    "DESC_EU_025"     VARCHAR2(600 BYTE) NOT NULL ENABLE,
    "ID_007_TP_DOC_DOKUSI" VARCHAR2(100 BYTE),
    "ID_007_ST_DOC_DOKUSI" VARCHAR2(100 BYTE),
    CONSTRAINT "SYS_C0066318" CHECK ("ID_025" IS NOT NULL) ENABLE,
    CONSTRAINT "PK_AB03B25T00" PRIMARY KEY ("ID_025") USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645 PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT) TABLESPACE "USERS" ENABLE,
    CONSTRAINT "FK_AB03B25T00_AB03B18T00" FOREIGN KEY ("ID_017_FASE","ID_018_TRAMITE") REFERENCES "AB03B"."AB03B18T00" ("ID_017_FASE", "ID_018") ENABLE,
	CONSTRAINT "FK_AB03B25T00_AB03B22T00" FOREIGN KEY ("ID_022_TIPO_PLAN") REFERENCES "AB03B"."AB03B22T00" ("ID_022") ENABLE,
	CONSTRAINT "FK_AB03B25T00_AB03B07T00_1" FOREIGN KEY ("ID_007_TP_DOC_DOKUSI") REFERENCES "AB03B"."AB03B07T00" ("ID_007") ENABLE,
	CONSTRAINT "FK_AB03B25T00_AB03B07T00_2" FOREIGN KEY ("ID_007_ST_DOC_DOKUSI") REFERENCES "AB03B"."AB03B07T00" ("ID_007") ENABLE
  )
  SEGMENT CREATION IMMEDIATE PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING STORAGE
  (
    INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645 PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT
  )
  TABLESPACE "AB0301E00" ;
COMMENT ON COLUMN "AB03B"."AB03B25T00"."ID_025"
IS
  'Clave primaria';
  COMMENT ON COLUMN "AB03B"."AB03B25T00"."ID_017_FASE"
IS
  'FK a Tabla de Fases RERA';
  COMMENT ON COLUMN "AB03B"."AB03B25T00"."ID_018_TRAMITE"
IS
  'FK a Tabla de Trmites RERA';
  COMMENT ON COLUMN "AB03B"."AB03B25T00"."ID_022_TIPO_PLAN"
IS
  'FK a Tipos de solicitud RERA';
  COMMENT ON COLUMN "AB03B"."AB03B25T00"."DESC_ES_025"
IS
  'Descripcin Castellano del Documento RERA';
  COMMENT ON COLUMN "AB03B"."AB03B25T00"."DESC_EU_025"
IS
  'Descripcin Euskera del Documento RERA';
  COMMENT ON COLUMN "AB03B"."AB03B25T00"."ID_007_TP_DOC_DOKUSI"
IS
  'Tipo de Documento de dokusi';
  COMMENT ON COLUMN "AB03B"."AB03B25T00"."ID_007_ST_DOC_DOKUSI"
IS
  'SubTipo de Documento de Dokusi';
 
  COMMENT ON TABLE "AB03B"."AB03B25T00"
IS
  'Documentacin de Solictudes RERA';
  
/*******************************************************************/

CREATE TABLE "AB03B"."AB03B26T00"
  (
    "ID_026"  NUMBER(8,0),
    "DESC_ES_026"    VARCHAR2(150 BYTE),
    "DESC_EU_026"    VARCHAR2(150 BYTE),
    "ID_023_CODJMS"     NUMBER(8,0),
    "META_INF_026"   VARCHAR2(640 BYTE),
	"ID_025_DOC_SOL"    	 NUMBER(8,0),
    CONSTRAINT "PK_AB03B26T00" PRIMARY KEY ("ID_026") USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645 PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT) TABLESPACE "USERS" ENABLE,
    CONSTRAINT "FK_AB03B26T00_AB03B23T00" FOREIGN KEY ("ID_023_CODJMS") REFERENCES "AB03B"."AB03B23T00" ("ID_023") ENABLE,
	CONSTRAINT "FK_AB03B26T00_AB03B25T00" FOREIGN KEY ("ID_025_DOC_SOL") REFERENCES "AB03B"."AB03B25T00" ("ID_025") ENABLE
 
  )
  SEGMENT CREATION IMMEDIATE PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING STORAGE
  (
    INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645 PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT
  )
  TABLESPACE "AB0301E00" ;
COMMENT ON COLUMN "AB03B"."AB03B26T00"."ID_026"
IS
  'OID del Documento';
  COMMENT ON COLUMN "AB03B"."AB03B26T00"."DESC_ES_026"
IS
  'Descripcin en castellano';
  COMMENT ON COLUMN "AB03B"."AB03B26T00"."DESC_EU_026"
IS
  'Descripcin en Euskera';
  COMMENT ON COLUMN "AB03B"."AB03B26T00"."ID_023_CODJMS"
IS
  'FK a la tabla 023 (Codigo de Solicitud Telemtica JMS RERA)';
  COMMENT ON COLUMN "AB03B"."AB03B26T00"."META_INF_026"
IS
  'Metainformacin del documento';
 COMMENT ON COLUMN "AB03B"."AB03B26T00"."ID_025_DOC_SOL"
IS
  'FK a la tabla 025: ID del documento de solicitudes RERA';  
  COMMENT ON TABLE "AB03B"."AB03B26T00"
IS
  'Tabla de OIDs Dokusi de entrada Telemtica RERA';  
  
/***************************************************************/

CREATE TABLE "AB03B"."AB03B27T00"
  (
    "ID_027"           NUMBER(8,0) NOT NULL ENABLE,
    "ID_017_FASE"      NUMBER(8,0),
    "ID_018_TRAMITE"   NUMBER(8,0),
    "DESC_ES_027"      VARCHAR2(400 BYTE),
    "DESC_EU_027"      VARCHAR2(400 BYTE),
	"ID_021_PLANTILLA"       NUMBER(8,0),
    "ID_007_TP_DOC_DOKUSI" VARCHAR2(100 BYTE),
    "ID_007_ST_DOC_DOKUSI" VARCHAR2(100 BYTE),
    CONSTRAINT "PK_AB03B27T00" PRIMARY KEY ("ID_027") USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645 PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT) TABLESPACE "USERS" ENABLE,
    CONSTRAINT "FK_AB03B27T00_AB03B18T00" FOREIGN KEY ("ID_017_FASE","ID_018_TRAMITE") REFERENCES "AB03B"."AB03B18T00" ("ID_017_FASE", "ID_018") ENABLE,
	CONSTRAINT "FK_AB03B27T00_AB03B21T00" FOREIGN KEY ("ID_021_PLANTILLA") REFERENCES "AB03B"."AB03B21T00" ("ID_021") ENABLE,
	CONSTRAINT "FK_AB03B27T00_AB03B07T00_1" FOREIGN KEY ("ID_007_TP_DOC_DOKUSI") REFERENCES "AB03B"."AB03B07T00" ("ID_007") ENABLE,
	CONSTRAINT "FK_AB03B27T00_AB03B07T00_2" FOREIGN KEY ("ID_007_ST_DOC_DOKUSI") REFERENCES "AB03B"."AB03B07T00" ("ID_007") ENABLE
  )
  SEGMENT CREATION IMMEDIATE PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING STORAGE
  (
    INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645 PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT
  )
   ;
COMMENT ON COLUMN "AB03B"."AB03B27T00"."ID_027"
IS
  'PK Secuencia de la tabla';
  COMMENT ON COLUMN "AB03B"."AB03B27T00"."ID_017_FASE"
IS
  'FK a Tabla de Fases';
  COMMENT ON COLUMN "AB03B"."AB03B27T00"."ID_018_TRAMITE"
IS
  'FK a Tabla de Trmites ';
 
  COMMENT ON COLUMN "AB03B"."AB03B27T00"."DESC_ES_027"
IS
  'Descripcin Castellano del Documento';
  COMMENT ON COLUMN "AB03B"."AB03B27T00"."DESC_EU_027"
IS
  'Descripcin Euskera del Documento ';
  COMMENT ON COLUMN "AB03B"."AB03B27T00"."ID_021_PLANTILLA"
IS
  'FK a tabla 27: ID de la plantilla RERA';
 
  COMMENT ON COLUMN "AB03B"."AB03B27T00"."ID_007_TP_DOC_DOKUSI"
IS
  'Tipo de Documento de Dokusi';
  COMMENT ON COLUMN "AB03B"."AB03B27T00"."ID_007_ST_DOC_DOKUSI"
IS
  'SubTipo de Docuento de Dokusi';
  COMMENT ON TABLE "AB03B"."AB03B27T00"
IS
  'Tabla de Tipos de Documentos de Expedientes RERA';  
  
/************************************************************************/
CREATE TABLE "AB03B"."AB03B28T00"
  (
    "ID_028"          NUMBER(8,0) NOT NULL ENABLE,
    "ID_017_FASE"     NUMBER(8,0),
    "ID_018_TRAMITE"     NUMBER(8,0),
    "ID_024_NUM_EXP"  NUMBER(8,0),
    "ID_ANO_024"      NUMBER(4,0),
    "F_ACTU_028" DATE,
    "USUA_028" VARCHAR2(120 BYTE),
    "F_REG_SAL_028" DATE,
    "N_REG_SAL_028" DATE,
    "F_NOTIF_028" DATE,
    "F_EXPIR_028" DATE,
    "F_MODIF_028" DATE,
    "USU_MOD_028" VARCHAR2(120 BYTE),
    "F_TRAMITACION_028" DATE,
    CONSTRAINT "PK_AB03B28T00" PRIMARY KEY ("ID_028") USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645 PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT) TABLESPACE "USERS" ENABLE,
    CONSTRAINT "FK_AB03B28T00_AB03B18T00" FOREIGN KEY ("ID_017_FASE","ID_018_TRAMITE") REFERENCES "AB03B"."AB03B18T00" ("ID_017_FASE", "ID_018") ENABLE,
	CONSTRAINT "FK_AB03B28T00_AB03B24T00" FOREIGN KEY ("ID_ANO_024", "ID_024_NUM_EXP") REFERENCES "AB03B"."AB03B24T00" ("ID_ANO_024", "ID_024") ENABLE
  )
  SEGMENT CREATION IMMEDIATE PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING STORAGE
  (
    INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645 PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT
  )
  TABLESPACE "AB0301E00" ;
COMMENT ON COLUMN "AB03B"."AB03B28T00"."ID_028"
IS
  'Secuencia - clave primaria de la tabla 28';
  COMMENT ON COLUMN "AB03B"."AB03B28T00"."ID_017_FASE"
IS
  'FK a tabla de Fases RERA';
  COMMENT ON COLUMN "AB03B"."AB03B28T00"."ID_018_TRAMITE"
IS
  'FK a Tabla de Trmites RERA';
  COMMENT ON COLUMN "AB03B"."AB03B28T00"."ID_024_NUM_EXP"
IS
  'FK a tabla de expedientes RERA';
  COMMENT ON COLUMN "AB03B"."AB03B28T00"."ID_ANO_024"
IS
  'Ao del expediente';
  COMMENT ON COLUMN "AB03B"."AB03B28T00"."F_ACTU_028"
IS
  'Fecha de actualizacin del estado';
  COMMENT ON COLUMN "AB03B"."AB03B28T00"."USUA_028"
IS
  'Usuario de actualizacin';
  COMMENT ON COLUMN "AB03B"."AB03B28T00"."F_REG_SAL_028"
IS
  'Fecha de salida del registro';
  COMMENT ON COLUMN "AB03B"."AB03B28T00"."N_REG_SAL_028"
IS
  'Nmero de registro de salida';
  COMMENT ON COLUMN "AB03B"."AB03B28T00"."F_NOTIF_028"
IS
  'Fecha de Notificacin';
  COMMENT ON COLUMN "AB03B"."AB03B28T00"."F_EXPIR_028"
IS
  'Fecha de expiracin de la notificacin';
  COMMENT ON COLUMN "AB03B"."AB03B28T00"."F_MODIF_028"
IS
  'Fecha de Modificacin';
  COMMENT ON COLUMN "AB03B"."AB03B28T00"."USU_MOD_028"
IS
  'Usuario de modificacin';
  COMMENT ON COLUMN "AB03B"."AB03B28T00"."F_TRAMITACION_028"
IS
  'Fecha de tramitacin';
  COMMENT ON TABLE "AB03B"."AB03B28T00"
IS
  'Historial de Tramitacin de un expediente RERA';
/******************************************************************/
CREATE TABLE "AB03B"."AB03B29T00"
  (
    "ID_029"            NUMBER(8,0) NOT NULL ENABLE,
    "ID_024_NUM_EXP"    NUMBER(8,0),
    "ID_ANO_024"        NUMBER(4,0),
    "ID_027_TIPO_DOC_G" NUMBER(8,0),
    "ID_028_HISTO_TRAM" NUMBER(8,0),
    "ID_PIF_029"        VARCHAR2(128 BYTE),
    "ID_026_OID"        NUMBER(8,0),
    CONSTRAINT "PK_AB03B29T00" PRIMARY KEY ("ID_029") USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645 PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT) TABLESPACE "USERS" ENABLE,
    CONSTRAINT "FK_AB03B29T00_AB03B24T00" FOREIGN KEY ("ID_ANO_024", "ID_024_NUM_EXP") REFERENCES "AB03B"."AB03B24T00" ("ID_ANO_024", "ID_024") ENABLE,
    CONSTRAINT "FK_AB03B29T00_AB03B27T00" FOREIGN KEY ("ID_027_TIPO_DOC_G") REFERENCES "AB03B"."AB03B27T00" ("ID_027") ENABLE,
    CONSTRAINT "FK_AB03B29T00_AB03B28T00" FOREIGN KEY ("ID_028_HISTO_TRAM") REFERENCES "AB03B"."AB03B28T00" ("ID_028") ENABLE,
    CONSTRAINT "FK_AB03B29T00_AB03B26T00" FOREIGN KEY ("ID_026_OID") REFERENCES "AB03B"."AB03B26T00" ("ID_026") ENABLE
  )
  SEGMENT CREATION IMMEDIATE PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING STORAGE
  (
    INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645 PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT
  )
  TABLESPACE "AB0301E00";
COMMENT ON COLUMN "AB03B"."AB03B29T00"."ID_029"
IS
  'PF Secuencial de la tabla';
  COMMENT ON COLUMN "AB03B"."AB03B29T00"."ID_024_NUM_EXP"
IS
  'FK a Tabla de Expedientes RERA';
  COMMENT ON COLUMN "AB03B"."AB03B29T00"."ID_027_TIPO_DOC_G"
IS
  'FK a Tipos de Documentacin Generada RERA';
  COMMENT ON COLUMN "AB03B"."AB03B29T00"."ID_028_HISTO_TRAM"
IS
  'FK a Historial de Tramitacin RERA';
  COMMENT ON COLUMN "AB03B"."AB03B29T00"."ID_PIF_029"
IS
  'Identificador del Documeto en PIF';
  COMMENT ON COLUMN "AB03B"."AB03B29T00"."ID_026_OID"
IS
  'FK a OID del Documento en Dokusi';
  COMMENT ON TABLE "AB03B"."AB03B29T00"
IS
  'Documentacin de expedientes RERA';
  
  

  
/***********************************************************************/


CREATE TABLE "AB03B"."AB03B30T00"
  (
    "ID_030"          NUMBER(8,0) NOT NULL ENABLE,
    "ID_024_NUM_EXP"  NUMBER(8,0),
    "ID_ANO_024"      NUMBER(4,0),
    "ID_006_TP_ACCESO"  CHAR(1 BYTE),
    "F_ACTU_030" DATE,
    "USU_MODIF_030" VARCHAR2(150 BYTE),
    CONSTRAINT "SYS_C0066319" CHECK ("F_ACTU_030" IS NOT NULL) ENABLE,
    CONSTRAINT "SYS_C0066320" CHECK ("ID_030"     IS NOT NULL) ENABLE,
    CONSTRAINT "PK_AB03B30T00" PRIMARY KEY ("ID_030") USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645 PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT) TABLESPACE "USERS" ENABLE,
    CONSTRAINT "FK_AB03B30T00_AB03B24T00" FOREIGN KEY ("ID_ANO_024", "ID_024_NUM_EXP") REFERENCES "AB03B"."AB03B24T00" ("ID_ANO_024", "ID_024") ENABLE,
    CONSTRAINT "FK_AB03B30T00_AB03B06T00" FOREIGN KEY ("ID_006_TP_ACCESO") REFERENCES "AB03B"."AB03B06T00" ("ID_006") ENABLE
  )
  SEGMENT CREATION IMMEDIATE PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING STORAGE
  (
    INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645 PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT
  )
  TABLESPACE "AB0301E00" ;
COMMENT ON COLUMN "AB03B"."AB03B30T00"."ID_030"
IS
  'Secuencia - Clave primaria de tabla AB03B30T00';

  COMMENT ON COLUMN "AB03B"."AB03B30T00"."ID_024_NUM_EXP"
IS
  'FK a Tabla de expedientes';
  COMMENT ON COLUMN "AB03B"."AB03B30T00"."ID_ANO_024"
IS
  'FK tabla de expedientes RERA - Ao del expediente ';
  COMMENT ON COLUMN "AB03B"."AB03B30T00"."ID_006_TP_ACCESO"
IS
  'FK a Tipo de Acceso';
  COMMENT ON COLUMN "AB03B"."AB03B30T00"."F_ACTU_030"
IS
  'Fecha de Actualizacin del resgistro';
  COMMENT ON COLUMN "AB03B"."AB03B30T00"."USU_MODIF_030"
IS
  'Usuario de acceso al resgistro';
  COMMENT ON TABLE "AB03B"."AB03B30T00"
IS
  'Tabla de Accesos a Expedientes RERA';
  
/****************************************************/

  
CREATE TABLE "AB03B"."AB03B31T00"
  (
    "ID_031"          NUMBER(8,0) NOT NULL ENABLE,
    "NIF_EMPRESA_031"  VARCHAR2(150 BYTE),
    "ESTADO_031"     CHAR(1 BYTE) DEFAULT '0',
    "F_CAMBIO_ESTADO_031"  DATE,
    CONSTRAINT "SYS_C0066321" CHECK ("ID_031"     IS NOT NULL) ENABLE,
    CONSTRAINT "PK_AB03B31T00" PRIMARY KEY ("ID_031") USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645 PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT) TABLESPACE "USERS" ENABLE
  )
  SEGMENT CREATION IMMEDIATE PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING STORAGE
  (
    INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645 PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT
  )
  TABLESPACE "AB0301E00" ;
COMMENT ON COLUMN "AB03B"."AB03B31T00"."ID_031"
IS
  'Secuencia - Clave primaria de tabla AB03B31T00';

  COMMENT ON COLUMN "AB03B"."AB03B31T00"."NIF_EMPRESA_031"
IS
  'NIF de la empresa';
  COMMENT ON COLUMN "AB03B"."AB03B31T00"."ESTADO_031"
IS
  'Estado de la empresa en RERA: 0-Alta 1-Baja ';
  COMMENT ON COLUMN "AB03B"."AB03B31T00"."F_CAMBIO_ESTADO_031"
IS
  'Fecha del cambio de estado alta/baja';
  
  COMMENT ON TABLE "AB03B"."AB03B31T00"
IS
  'Tabla de Histrico de altas/bajas de una empresa en RERA';
  
/*********************************************/  


CREATE TABLE "AB03B"."AB03B32T00"
  (
    "ID_032"          NUMBER(8,0) NOT NULL ENABLE,
    "ID_024_NUM_EXP"  NUMBER(8,0),
    "ID_ANO_024"      NUMBER(4,0),
    "NIF_EMPRESA_032" VARCHAR2(150 BYTE),
    "NOMBRE_032"   VARCHAR2(150 BYTE),
    "APELLIDO1_032" VARCHAR2(150 BYTE),
	"APELLIDO2_032" VARCHAR2(150 BYTE),
	"ESTADO_032" CHAR(1 BYTE) DEFAULT '0',
   CONSTRAINT "SYS_C0066322" CHECK ("ID_032"     IS NOT NULL) ENABLE,
    CONSTRAINT "PK_AB03B32T00" PRIMARY KEY ("ID_032") USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645 PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT) TABLESPACE "USERS" ENABLE,
    CONSTRAINT "FK_AB03B32T00_AB03B24T00" FOREIGN KEY ("ID_ANO_024", "ID_024_NUM_EXP") REFERENCES "AB03B"."AB03B24T00" ("ID_ANO_024", "ID_024") ENABLE
  )
  SEGMENT CREATION IMMEDIATE PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING STORAGE
  (
    INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645 PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT
  )
  TABLESPACE "AB0301E00" ;
COMMENT ON COLUMN "AB03B"."AB03B32T00"."ID_032"
IS
  'Secuencia - Clave primaria de tabla AB03B32T00';

  COMMENT ON COLUMN "AB03B"."AB03B32T00"."ID_024_NUM_EXP"
IS
  'FK a Tabla de expedientes RERA';
  COMMENT ON COLUMN "AB03B"."AB03B32T00"."ID_ANO_024"
IS
  'FK tabla de expedientes RERA - Ao del expediente ';
  COMMENT ON COLUMN "AB03B"."AB03B32T00"."NIF_EMPRESA_032"
IS
  'NIF de la empresa';
  COMMENT ON COLUMN "AB03B"."AB03B32T00"."NOMBRE_032"
IS
  'Nombre del trabajador';
  COMMENT ON COLUMN "AB03B"."AB03B32T00"."APELLIDO1_032"
IS
  'Apellido 1 del trabajador';
COMMENT ON COLUMN "AB03B"."AB03B32T00"."APELLIDO2_032"
IS
  'Apellido 2 del trabajador';
COMMENT ON COLUMN "AB03B"."AB03B32T00"."ESTADO_032"
IS
  'Estado del trabajador en trabajos RERA: 0-Alta 1-Baja'; 
  COMMENT ON TABLE "AB03B"."AB03B32T00"
IS
  'Tabla de trabajadores por empresa RERA';


/***************************************************************************/

ALTER TABLE "AB03B"."AB03B10T00"
ADD CONSTRAINT FK_AB03B10T00_AB03B24T00
   FOREIGN KEY ("ID_024_RERA", "ID_ANO_024_RERA")
   REFERENCES "AB03B"."AB03B24T00" ("ID_ANO_024", "ID_024");
   
/*************************************************************************/   
   
COMMIT;     

/*
DROP  TABLE "AB03B"."AB03B32T00";
DROP  TABLE "AB03B"."AB03B31T00";
DROP  TABLE "AB03B"."AB03B30T00";
DROP  TABLE "AB03B"."AB03B29T00";
DROP  TABLE "AB03B"."AB03B28T00";
DROP  TABLE "AB03B"."AB03B27T00";
DROP  TABLE "AB03B"."AB03B26T00";
DROP  TABLE "AB03B"."AB03B25T00";
DROP  TABLE "AB03B"."AB03B24T00";
DROP  TABLE "AB03B"."AB03B23T00";
DROP  TABLE "AB03B"."AB03B22T00";
DROP  TABLE "AB03B"."AB03B21T00";
DROP  TABLE "AB03B"."AB03B20T00";
DROP  TABLE "AB03B"."AB03B19T00";
DROP  TABLE "AB03B"."AB03B18T00";
DROP  TABLE "AB03B"."AB03B17T00";
DROP  TABLE "AB03B"."AB03B16T00";
DROP  TABLE "AB03B"."AB03B15T00";
DROP  TABLE "AB03B"."AB03B14T00";
DROP  TABLE "AB03B"."AB03B13T00";
DROP  TABLE "AB03B"."AB03B12T00";
DROP  TABLE "AB03B"."AB03B11T00";
DROP  TABLE "AB03B"."AB03B10T00";
DROP  TABLE "AB03B"."AB03B09T00";
DROP  TABLE "AB03B"."AB03B08T00";
DROP  TABLE "AB03B"."AB03B07T00";
DROP  TABLE "AB03B"."AB03B06T00";
DROP  TABLE "AB03B"."AB03B05T00";
DROP  TABLE "AB03B"."AB03B04T00";
DROP  TABLE "AB03B"."AB03B03T00";
DROP  TABLE "AB03B"."AB03B02T00";
DROP  TABLE "AB03B"."AB03B01T00";*/
